/************************************************************************
* \file: trace_impl.c
*
* \version: $Id: trace_impl.c,v 1.25 2012/05/30 08:27:03 jayanth.mc Exp $
*
* This file implements common functionalities of FE and BE
* Linux specific implementations copied from t-kernel is also put here
*
* \component: Gen2 Trace
*
* \author   B. Das         bhaskar.das(o)in.bosch.com
*           Sakthivelu S.  sakthivelu.s(o)in.bosch.com          
* \modified:Arun V
* \copyright: (c) 2003 - 2009 ADIT
*
***********************************************************************/

#include <pfcfg_interface.h>

#include <pwd.h>
#include <grp.h>
#include <libgen.h>
#include "trace_base.h"
#include "trace_UsrCfg.h"


/*SWGIII-3621: TRACE static constructor for init() dangerous */
IMPORT TRACE_start_fp TRACE_init_fp;
pthread_mutex_t init_lock = PTHREAD_MUTEX_INITIALIZER;

LOCAL TRACE_cfg g_TRACE_cfg;


LOCAL U16 g_TRACE_compcnt[]= {
  TR_MAX_CLSCNT_COMP000, TR_MAX_CLSCNT_COMP001, TR_MAX_CLSCNT_COMP002,
  TR_MAX_CLSCNT_COMP003, TR_MAX_CLSCNT_COMP004, TR_MAX_CLSCNT_COMP005,
  TR_MAX_CLSCNT_COMP006, TR_MAX_CLSCNT_COMP007, TR_MAX_CLSCNT_COMP008,
  TR_MAX_CLSCNT_COMP009, TR_MAX_CLSCNT_COMP010, TR_MAX_CLSCNT_COMP011,
  TR_MAX_CLSCNT_COMP012, TR_MAX_CLSCNT_COMP013, TR_MAX_CLSCNT_COMP014,
  TR_MAX_CLSCNT_COMP015, TR_MAX_CLSCNT_COMP016, TR_MAX_CLSCNT_COMP017,
  TR_MAX_CLSCNT_COMP018, TR_MAX_CLSCNT_COMP019, TR_MAX_CLSCNT_COMP020,
  TR_MAX_CLSCNT_COMP021, TR_MAX_CLSCNT_COMP022, TR_MAX_CLSCNT_COMP023,
  TR_MAX_CLSCNT_COMP024, TR_MAX_CLSCNT_COMP025, TR_MAX_CLSCNT_COMP026,
  TR_MAX_CLSCNT_COMP027, TR_MAX_CLSCNT_COMP028, TR_MAX_CLSCNT_COMP029,
  TR_MAX_CLSCNT_COMP030, TR_MAX_CLSCNT_COMP031, TR_MAX_CLSCNT_COMP032,
  TR_MAX_CLSCNT_COMP033, TR_MAX_CLSCNT_COMP034, TR_MAX_CLSCNT_COMP035,
  TR_MAX_CLSCNT_COMP036, TR_MAX_CLSCNT_COMP037, TR_MAX_CLSCNT_COMP038,
  TR_MAX_CLSCNT_COMP039, TR_MAX_CLSCNT_COMP040, TR_MAX_CLSCNT_COMP041,
  TR_MAX_CLSCNT_COMP042, TR_MAX_CLSCNT_COMP043, TR_MAX_CLSCNT_COMP044,
  TR_MAX_CLSCNT_COMP045, TR_MAX_CLSCNT_COMP046, TR_MAX_CLSCNT_COMP047,
  TR_MAX_CLSCNT_COMP048, TR_MAX_CLSCNT_COMP049, TR_MAX_CLSCNT_COMP050,
  TR_MAX_CLSCNT_COMP051, TR_MAX_CLSCNT_COMP052, TR_MAX_CLSCNT_COMP053,
  TR_MAX_CLSCNT_COMP054, TR_MAX_CLSCNT_COMP055, TR_MAX_CLSCNT_COMP056,
  TR_MAX_CLSCNT_COMP057, TR_MAX_CLSCNT_COMP058, TR_MAX_CLSCNT_COMP059,
  TR_MAX_CLSCNT_COMP060, TR_MAX_CLSCNT_COMP061, TR_MAX_CLSCNT_COMP062,
  TR_MAX_CLSCNT_COMP063, TR_MAX_CLSCNT_COMP064, TR_MAX_CLSCNT_COMP065,
  TR_MAX_CLSCNT_COMP066, TR_MAX_CLSCNT_COMP067, TR_MAX_CLSCNT_COMP068,
  TR_MAX_CLSCNT_COMP069, TR_MAX_CLSCNT_COMP070, TR_MAX_CLSCNT_COMP071,
  TR_MAX_CLSCNT_COMP072, TR_MAX_CLSCNT_COMP073, TR_MAX_CLSCNT_COMP074,
  TR_MAX_CLSCNT_COMP075, TR_MAX_CLSCNT_COMP076, TR_MAX_CLSCNT_COMP077,
  TR_MAX_CLSCNT_COMP078, TR_MAX_CLSCNT_COMP079, TR_MAX_CLSCNT_COMP080,
  TR_MAX_CLSCNT_COMP081, TR_MAX_CLSCNT_COMP082, TR_MAX_CLSCNT_COMP083,
  TR_MAX_CLSCNT_COMP084, TR_MAX_CLSCNT_COMP085, TR_MAX_CLSCNT_COMP086,
  TR_MAX_CLSCNT_COMP087, TR_MAX_CLSCNT_COMP088, TR_MAX_CLSCNT_COMP089,
  TR_MAX_CLSCNT_COMP090, TR_MAX_CLSCNT_COMP091, TR_MAX_CLSCNT_COMP092,
  TR_MAX_CLSCNT_COMP093, TR_MAX_CLSCNT_COMP094, TR_MAX_CLSCNT_COMP095,
  TR_MAX_CLSCNT_COMP096, TR_MAX_CLSCNT_COMP097, TR_MAX_CLSCNT_COMP098,
  TR_MAX_CLSCNT_COMP099, TR_MAX_CLSCNT_COMP100, TR_MAX_CLSCNT_COMP101,
  TR_MAX_CLSCNT_COMP102, TR_MAX_CLSCNT_COMP103, TR_MAX_CLSCNT_COMP104,
  TR_MAX_CLSCNT_COMP105, TR_MAX_CLSCNT_COMP106, TR_MAX_CLSCNT_COMP107,
  TR_MAX_CLSCNT_COMP108, TR_MAX_CLSCNT_COMP109, TR_MAX_CLSCNT_COMP110,
  TR_MAX_CLSCNT_COMP111, TR_MAX_CLSCNT_COMP112, TR_MAX_CLSCNT_COMP113,
  TR_MAX_CLSCNT_COMP114, TR_MAX_CLSCNT_COMP115, TR_MAX_CLSCNT_COMP116,
  TR_MAX_CLSCNT_COMP117, TR_MAX_CLSCNT_COMP118, TR_MAX_CLSCNT_COMP119,
  TR_MAX_CLSCNT_COMP120, TR_MAX_CLSCNT_COMP121, TR_MAX_CLSCNT_COMP122,
  TR_MAX_CLSCNT_COMP123, TR_MAX_CLSCNT_COMP124, TR_MAX_CLSCNT_COMP125,
  TR_MAX_CLSCNT_COMP126, TR_MAX_CLSCNT_COMP127, TR_MAX_CLSCNT_COMP128,
  TR_MAX_CLSCNT_COMP129, TR_MAX_CLSCNT_COMP130, TR_MAX_CLSCNT_COMP131,
  TR_MAX_CLSCNT_COMP132, TR_MAX_CLSCNT_COMP133, TR_MAX_CLSCNT_COMP134,
  TR_MAX_CLSCNT_COMP135, TR_MAX_CLSCNT_COMP136, TR_MAX_CLSCNT_COMP137,
  TR_MAX_CLSCNT_COMP138, TR_MAX_CLSCNT_COMP139, TR_MAX_CLSCNT_COMP140,
  TR_MAX_CLSCNT_COMP141, TR_MAX_CLSCNT_COMP142, TR_MAX_CLSCNT_COMP143,
  TR_MAX_CLSCNT_COMP144, TR_MAX_CLSCNT_COMP145, TR_MAX_CLSCNT_COMP146,
  TR_MAX_CLSCNT_COMP147, TR_MAX_CLSCNT_COMP148, TR_MAX_CLSCNT_COMP149,
  TR_MAX_CLSCNT_COMP150, TR_MAX_CLSCNT_COMP151, TR_MAX_CLSCNT_COMP152,
  TR_MAX_CLSCNT_COMP153, TR_MAX_CLSCNT_COMP154, TR_MAX_CLSCNT_COMP155,
  TR_MAX_CLSCNT_COMP156, TR_MAX_CLSCNT_COMP157, TR_MAX_CLSCNT_COMP158,
  TR_MAX_CLSCNT_COMP159, TR_MAX_CLSCNT_COMP160, TR_MAX_CLSCNT_COMP161,
  TR_MAX_CLSCNT_COMP162, TR_MAX_CLSCNT_COMP163, TR_MAX_CLSCNT_COMP164,
  TR_MAX_CLSCNT_COMP165, TR_MAX_CLSCNT_COMP166, TR_MAX_CLSCNT_COMP167,
  TR_MAX_CLSCNT_COMP168, TR_MAX_CLSCNT_COMP169, TR_MAX_CLSCNT_COMP170,
  TR_MAX_CLSCNT_COMP171, TR_MAX_CLSCNT_COMP172, TR_MAX_CLSCNT_COMP173,
  TR_MAX_CLSCNT_COMP174, TR_MAX_CLSCNT_COMP175, TR_MAX_CLSCNT_COMP176,
  TR_MAX_CLSCNT_COMP177, TR_MAX_CLSCNT_COMP178, TR_MAX_CLSCNT_COMP179,
  TR_MAX_CLSCNT_COMP180, TR_MAX_CLSCNT_COMP181, TR_MAX_CLSCNT_COMP182,
  TR_MAX_CLSCNT_COMP183, TR_MAX_CLSCNT_COMP184, TR_MAX_CLSCNT_COMP185,
  TR_MAX_CLSCNT_COMP186, TR_MAX_CLSCNT_COMP187, TR_MAX_CLSCNT_COMP188,
  TR_MAX_CLSCNT_COMP189, TR_MAX_CLSCNT_COMP190, TR_MAX_CLSCNT_COMP191,
  TR_MAX_CLSCNT_COMP192, TR_MAX_CLSCNT_COMP193, TR_MAX_CLSCNT_COMP194,
  TR_MAX_CLSCNT_COMP195, TR_MAX_CLSCNT_COMP196, TR_MAX_CLSCNT_COMP197,
  TR_MAX_CLSCNT_COMP198, TR_MAX_CLSCNT_COMP199, TR_MAX_CLSCNT_COMP200,
  TR_MAX_CLSCNT_COMP201, TR_MAX_CLSCNT_COMP202, TR_MAX_CLSCNT_COMP203,
  TR_MAX_CLSCNT_COMP204, TR_MAX_CLSCNT_COMP205, TR_MAX_CLSCNT_COMP206,
  TR_MAX_CLSCNT_COMP207, TR_MAX_CLSCNT_COMP208, TR_MAX_CLSCNT_COMP209,
  TR_MAX_CLSCNT_COMP210, TR_MAX_CLSCNT_COMP211, TR_MAX_CLSCNT_COMP212,
  TR_MAX_CLSCNT_COMP213, TR_MAX_CLSCNT_COMP214, TR_MAX_CLSCNT_COMP215,
  TR_MAX_CLSCNT_COMP216, TR_MAX_CLSCNT_COMP217, TR_MAX_CLSCNT_COMP218,
  TR_MAX_CLSCNT_COMP219, TR_MAX_CLSCNT_COMP220, TR_MAX_CLSCNT_COMP221,
  TR_MAX_CLSCNT_COMP222, TR_MAX_CLSCNT_COMP223, TR_MAX_CLSCNT_COMP224,
  TR_MAX_CLSCNT_COMP225, TR_MAX_CLSCNT_COMP226, TR_MAX_CLSCNT_COMP227,
  TR_MAX_CLSCNT_COMP228, TR_MAX_CLSCNT_COMP229, TR_MAX_CLSCNT_COMP230,
  TR_MAX_CLSCNT_COMP231, TR_MAX_CLSCNT_COMP232, TR_MAX_CLSCNT_COMP233,
  TR_MAX_CLSCNT_COMP234, TR_MAX_CLSCNT_COMP235, TR_MAX_CLSCNT_COMP236,
  TR_MAX_CLSCNT_COMP237, TR_MAX_CLSCNT_COMP238, TR_MAX_CLSCNT_COMP239,
  TR_MAX_CLSCNT_COMP240, TR_MAX_CLSCNT_COMP241, TR_MAX_CLSCNT_COMP242,
  TR_MAX_CLSCNT_COMP243, TR_MAX_CLSCNT_COMP244, TR_MAX_CLSCNT_COMP245,
  TR_MAX_CLSCNT_COMP246, TR_MAX_CLSCNT_COMP247, TR_MAX_CLSCNT_COMP248,
  TR_MAX_CLSCNT_COMP249, TR_MAX_CLSCNT_COMP250, TR_MAX_CLSCNT_COMP251,
  TR_MAX_CLSCNT_COMP252, TR_MAX_CLSCNT_COMP253, TR_MAX_CLSCNT_COMP254,
  TR_MAX_CLSCNT_COMP255};


/**
* Create header for trace packet
*
* \parm len      Packet length
* \parm clas     Trace class
* \parm lvl      Trace level
* \parm hdr      Pointer to trace packet header field
* \parm msg_type Trace message type
*
* return \li E_OK    if successful
*                    else error values returned by concrete implementation.
*/
EXPORT void TRACE_cre_hdr(U32 len, U16 clas, U8 lvl, TRACE_OUT_HDR* hdr,
                          U8 msg_typ)
{
    hdr->core_no      = UTIL_get_cpu_core();
    hdr->len          = len + sizeof(TRACE_OUT_HDR);
    hdr->proc_id      = 0;
    hdr->multi_pack   = msg_typ;
    hdr->pack_typ     = 0;
    hdr->comp_id      = TR_COMPID(clas);
    hdr->class_id     = TR_CLASID(clas);
    hdr->level        = lvl;
    hdr->state_byte   = 0;
    hdr->rsvd         = 0;
}

/**
* Send status messages to TTFis
*
* \parm mgr Pointer to Trace manager
* \parm mgr buf Pointer to status messge
* \parm len length of the status message
* return \li E_OK    if successful
*                    else error values returned by concrete implementation.
*/
EXPORT ER TRACE_snd_status(TRACE_mgr* mgr, const U8* buf, U8 len)
{
    TRACE_TRACEOUT_MSG pkt;
    ER                 rc  = E_FAIL;

    mgr = mgr;
    memset(&pkt, 0, sizeof(pkt));
    pkt.tm_stamp = TRACE_TIMESTAMP_DISABLE;
 
    if(len <= sizeof(pkt.pkt.trc_msg.out_pkt.payld))
    {
        TRACE_cre_hdr(len, TR_CLASS_TRACE, TRACE_STATUS_INFO,
            &pkt.pkt.trc_msg.out_pkt.hdr, TR_MSG_NORMAL);
        memcpy((VP)&pkt.pkt.trc_msg.out_pkt.payld, buf, len);
        rc = TRACE_q_push(&mgr->stat.buf, &pkt);
    }
    return rc;
}


/**
 * Set static class cnfg for early tracing
 *
 * \param mgr Pointer to trace configuration
 *
 * \return none
 */
LOCAL void TRACE_ena_static_clas(TRACE_mgr* mgr);
LOCAL void TRACE_ena_static_clas(TRACE_mgr* mgr)
{
  S32 i                  = 0;
  U8  comp_id            = 0;
  U8  clas_id            = 0;
  TRACE_comp_inf* comp   = NULL;
  U8  lvl                = TR_LEVEL_FOR_CLASSES_FROM_USER;

  mgr = mgr;
  for(; i < TR_COUNT_CLASSES_FROM_USER; i++)
  {
    comp_id = (U8)TR_COMPID(trClassFromUser[i]);
    clas_id = (U8)TR_CLASID(trClassFromUser[i]);

    comp = &mgr->c_cnfg->comp[comp_id];
    if(clas_id < comp->max_clas)
    {
      comp->lvl[clas_id].trc_lvl = lvl;
    }
  }
}

/**
 * Init Trace Q
 *
 * \parm  q_dst Pointer to destination buffer
 * \parm  q_src Pointer to source buffer
 *
 * return \li None
 */
LOCAL void TRACE_ini_q(TRACE_q* q_dst, const TRACE_q* const q_src);
LOCAL void TRACE_ini_q(TRACE_q* q_dst, const TRACE_q* const q_src)
{
  memcpy(q_dst, q_src, sizeof(TRACE_q));
}

/**
 * Init Trace Q - shared info
 *
 * \parm  q_dst Pointer to destination buffer
 * \parm  q_src Pointer to source buffer
 *
 * return \li None
 */
LOCAL void TRACE_ini_q_sh(TRACE_q_sh* q_dst, const TRACE_q_sh* const q_src);
LOCAL void TRACE_ini_q_sh(TRACE_q_sh* q_dst, const TRACE_q_sh* const q_src)
{
  memcpy(q_dst, q_src, sizeof(TRACE_q_sh));
  /* Fix: SWGIIX-179 calling mutex_init on already initialized mutex
   * may cause undefined behaviour [assertion, trace stuck after a while]
   * moved from TRACE_ini_q to this shared init so that it is done only once
   */
  TRACE_q_lock_init(&q_dst->lock);
}

/**
 * Allocate shared memory for Trace
 *
 * \parm  mgr Pointer to Trace manager
 * \parm  mem Pointer to cnfg in shared mem
 *
 * return \li E_OK    if successful
 *                    else error values returned by concrete implementation.
 */
LOCAL ER TRACE_alloc_shared_mem(TRACE_mgr* mgr, U8* mem);
LOCAL ER TRACE_alloc_shared_mem(TRACE_mgr* mgr, U8* mem)
{
  TRACE_comp_inf*   comp    = NULL;
  U32                i      = 0;
  ER                 rc     = E_OK;
  TRACE_class_cnfg* inf     = mgr->c_cnfg;
  
  if(mem != NULL)
  {  
  
    for(i = 0; i < UTIL_NO(g_TRACE_compcnt); i++)
    {
      comp = &inf->comp[i];
      comp->max_clas = g_TRACE_compcnt[i];
      if(comp->max_clas > 0)
      {
        comp->lvl  = (TRACE_lvl*)(VP) mem;
        mem += comp->max_clas;
      }
    }
  }
  return rc;
}



/**
 * Read Trace specific entries from devconf file.
 *
 * \parm  None
 *
 * return \li E_OK    if successful
 *                    else error values returned by concrete implementation.
 */
LOCAL ER TRACE_rd_devconf(void);
LOCAL ER TRACE_rd_devconf(void)
{
  ER rc = E_OK;
  U32 i  = 0;

  TRACE_devcnf_err* errmsg = &g_TRACE_cfg.item_failed;

  struct { U8* nm; U8* buf; S32 mx; } dstr[] = {
  {(VP)TRACE_IP_ADDR,            (VP)&g_TRACE_cfg.tcp_ip_addr,   L_IPADDR},
  {(VP)TRACE_SRL_DEV_NM,         (VP)&g_TRACE_cfg.serial_dev_nm,  TRACE_DEVNM_LEN},
  {(VP)TRACE_SOCK_DEV_NM,        (VP)&g_TRACE_cfg.sim_dev_nm,     TRACE_DEVNM_LEN},
  {(VP)TRACE_USBH_DEV_NM,        (VP)&g_TRACE_cfg.usb_h_dev_nm,   TRACE_DEVNM_LEN},
  {(VP)TRACE_USBF_DEV_NM,        (VP)&g_TRACE_cfg.usb_f_dev_nm,   TRACE_DEVNM_LEN},
  {(VP)TRACE_CFG_LOC,            (VP)&g_TRACE_cfg.trc_cfg_loc,    TRACE_DEVNM_LEN},
  {(VP)TRACE_BINSCRPT_LOC,       (VP)&g_TRACE_cfg.script_file_loc,TRACE_DEVNM_LEN},
  {(VP)TRACE_BINSCRPT_FILE_NM,   (VP)&g_TRACE_cfg.script_file_nm,TRACE_FILE_NM_LEN},
  {(VP)TRACE_PRXY_LOG_LOC,       (VP)&g_TRACE_cfg.prxy_bin_loc,   TRACE_DEVNM_LEN},
  {(VP)TRACE_PRXY_CFG_LOC,       (VP)&g_TRACE_cfg.prxy_cfg_loc,   TRACE_DEVNM_LEN},
  {(VP)TRACE_CHNL_SOCKET,        (VP)&g_TRACE_cfg.chnl_skt_loc,  TRACE_DEVNM_LEN},
  {(VP)TRACE_NOTIFY_SOCKET,      (VP)&g_TRACE_cfg.chnl_skt_ntfy_loc,  TRACE_DEVNM_LEN},
  {(VP)TRACE_TMPFILESD_CFG,      (VP)&g_TRACE_cfg.tmpfilesd_cfg_path,  TRACE_DEVNM_LEN}
  };

  struct { U8* nm; S32* val; S32 cnt; } dcfg[] = {
  {(VP)TRACE_PRXY_LOG_MOD,      (VP)&g_TRACE_cfg.prxy_flush_mode,    1},
  {(VP)TRACE_PRXY_LOG_MAXS,     (VP)&g_TRACE_cfg.prxy_max_sz,        1},
  {(VP)TRACE_PRXY_LOG_S,        (VP)&g_TRACE_cfg.prxy_log_sz,        1},
  {(VP)TRACE_FXD_MEM_STAR,      (VP)&g_TRACE_cfg.fixed_mem_start,    1},
  {(VP)TRACE_FXD_MEM_EN,        (VP)&g_TRACE_cfg.fixed_mem_end,      1},
  {(VP)TRACE_IO_TMOU,           (VP)&g_TRACE_cfg.io_tmo,             1},
  {(VP)TRACE_CYCLIC_INTERVA,    (VP)&g_TRACE_cfg.cyclic_hdlr_tmo,    1},
  {(VP)TRACE_KAHOST_PORTN,      (VP)&g_TRACE_cfg.tcp_port_no,        1},
  {(VP)TRACE_FEA_FIXED_ME,      (VP)&g_TRACE_cfg.flag_use_fixedmem,  1},
  {(VP)TRACE_FEA_CYC_OUTPU,     (VP)&g_TRACE_cfg.flag_use_cyclic_op, 1},
  {(VP)TRACE_OUTPUT_CHA,        (VP)&g_TRACE_cfg.output_mode,        1},
  {(VP)TRACE_TIMESTAMP_MOD,     (VP)&g_TRACE_cfg.timestamp_mode,     1},
  {(VP)TRACE_TRIP_MOD,          (VP)&g_TRACE_cfg.trip_mode,          1},
  {(VP)TRACE_STAT_MOD,          (VP)&g_TRACE_cfg.status_mode,        1},
  {(VP)TRACE_APPFILTER,         (VP)&g_TRACE_cfg.app_filter,         1},
  {(VP)TRACE_TSK_PR,            (VP)&g_TRACE_cfg.pri,   (S32)TRACE_MAX_TASK},
  {(VP)TRACE_TSK_STKS,          (VP)&g_TRACE_cfg.stksz, (S32)TRACE_MAX_TASK},
  {(VP)TRACE_TSK_LCI,           (VP)&g_TRACE_cfg.lcid,  (S32)TRACE_MAX_TASK},
  {(VP)TRACE_DEV_BUF_S,         (VP)&g_TRACE_cfg.trace_q_sz,         1},
  {(VP)TRACE_CHAN_BUF_S,        (VP)&g_TRACE_cfg.chan_q_sz,          1},
  {(VP)TRACE_PRXY_BUF_S,        (VP)&g_TRACE_cfg.prxy_q_sz,          1},
  {(VP)TRACE_STAT_BUF_S,        (VP)&g_TRACE_cfg.stat_q_sz,          1},
  {(VP)TRACE_LRG_PKT_S,         (VP)&g_TRACE_cfg.lrg_pkt_sz,         1},
  {(VP)TRACE_DFLT_TCP_KEEPALIVE,(VP)&g_TRACE_cfg.tcp_keepAlive,      1}
  };


  { /* For opening PFCFG config file */
    VP id = NULL;

    /* initialize config - no need to initialize empty strings as c runtime will initialize bss */
    strncpy((char*)&g_TRACE_cfg.tmpfilesd_cfg_path, TRACE_TMPFILESD_CFG_DEFAULT, TRACE_DEVNM_LEN);

    id = PFCFG_opn_cnf("adit_trace", PFCFG_READ);
    if(id)
    {
      TRACE_SYSLOG(TRACE_SYSLOG_NOTICE, "Opened adit_trace cfg file successfully\n");
    }
    else
    {
      TRACE_SYSLOG(TRACE_SYSLOG_ERROR, "Opening adit_trace cfg file FAILED\n");
      /*Trace could not proceed since configuration file is not present, so returning E_FAIL*/
      return E_FAIL;
    }
    for(; i < UTIL_NO(dcfg); i++)
    {
      rc = PFCFG_get_cfn(id, (char*)dcfg[i].nm, dcfg[i].val, dcfg[i].cnt);
      if(rc < E_OK)
      {
        errmsg->item[errmsg->cnt++] = (U8)i;
        rc = E_OK;
        /* todo: traceout errinfo to ttfis once backend is up */
      }
    }
    for(i = 0; i < UTIL_NO(dstr); i++)
    {
      rc = PFCFG_get_cfs(id, (char*)dstr[i].nm, (char*)dstr[i].buf, dstr[i].mx);
      if(rc < E_OK)
      {
        errmsg->item[errmsg->cnt++] = (U8)(i + UTIL_NO(dcfg));
        rc = E_OK;
        /* todo: traceout errinfo to ttfis once backend is up */
      }
    }

 /*SWGIII-7042 Fix */
    PFCFG_get_cfs(id, "TRACE_CHNL_SOCKET", (VP)&g_TRACE_cfg.chnl_skt_loc, TRACE_DEVNM_LEN);
    PFCFG_get_cfs(id, "TRACE_NOTIFY_SOCKET", (VP)&g_TRACE_cfg.chnl_skt_ntfy_loc, TRACE_DEVNM_LEN);

    PFCFG_close_cnf(id);

 } /* For opening PFCFG config file */

  if((g_TRACE_cfg.trace_q_sz == 0) || (g_TRACE_cfg.chan_q_sz  == 0) ||
     (g_TRACE_cfg.prxy_q_sz  == 0) || (g_TRACE_cfg.stat_q_sz  == 0) || 
     (g_TRACE_cfg.lrg_pkt_sz == 0) || (g_TRACE_cfg.prxy_max_sz == 0)||
     (g_TRACE_cfg.prxy_log_sz== 0))
  {
    rc = E_FAIL;
  }
  else
  {
    /* Convert KB into bytes */
    g_TRACE_cfg.stat_q_sz  = g_TRACE_cfg.stat_q_sz  * TRACE_KB_SZ;
    g_TRACE_cfg.lrg_pkt_sz = g_TRACE_cfg.lrg_pkt_sz * TRACE_KB_SZ;
    g_TRACE_cfg.prxy_q_sz  = g_TRACE_cfg.prxy_q_sz  * TRACE_KB_SZ;
    g_TRACE_cfg.chan_q_sz  = g_TRACE_cfg.chan_q_sz  * TRACE_KB_SZ;
    g_TRACE_cfg.trace_q_sz = g_TRACE_cfg.trace_q_sz * TRACE_KB_SZ;
    g_TRACE_cfg.prxy_max_sz= g_TRACE_cfg.prxy_max_sz * TRACE_KB_SZ;
    g_TRACE_cfg.prxy_log_sz= g_TRACE_cfg.prxy_log_sz * TRACE_KB_SZ;
  }
  return rc;
}

/**
 * Initialize Trace manager.
 *
 * \parm mgr Pointer to Trace manager
 *
 * return \li E_OK    if successful
 *                    else error values returned by concrete implementation.
 */
LOCAL void TRACE_init_mgr(TRACE_mgr* mgr);
LOCAL void TRACE_init_mgr(TRACE_mgr* mgr)
{
  S32         i            = 0; 
  TRACE_uart  uart         = {{0}, 5000, 5000, 0x55, 0xaa};
  TRACE_sim   sim          = {{0}, 7000};
  TRACE_proxy pxy          = {{0}, {0}};

  strncpy((VP)uart.nm, (VP)g_TRACE_cfg.serial_dev_nm, TRACE_DEVNM_LEN);
  strncpy((VP)sim.nm, (VP)g_TRACE_cfg.serial_dev_nm, TRACE_DEVNM_LEN);

  mgr->io_cfg[TRACE_UART].io_dev.dev_uart   = uart;
  mgr->io_cfg[TRACE_SIM].io_dev.dev_sim     = sim;
  mgr->io_cfg[TRACE_PROXY].io_dev.dev_pxy   = pxy;

  for(i = 0; i < (S32)TRACE_MAX_IO_DEV; i++)
  {
    mgr->io_cfg[i].io_timeout = g_TRACE_cfg.io_tmo;
    mgr->io_cfg[i].rtry_cnt   = TRACE_IO_RTRY_CNT;
    mgr->io_cfg[i].max_frmsz  = TRACE_MAX_FRAME_SZ;
    mgr->io_cfg[i].max_pktcnt = TRACE_MAX_PKT_CNT;
    mgr->io_cfg[i].min_pktcnt = TRACE_MIN_PKT_CNT;
    mgr->io_cfg[i].chksum     = FALSE;
  }

  /* Checksum is required for RS-232 */
  mgr->io_cfg[TRACE_UART].chksum = TRUE;

  mgr->flow_ctrl = TRACE_NO_SIG;
  
  /* these are BE tasks */
  for(i = 0; i < (S32)TRACE_MAX_TASK; i++)
  {
     mgr->ctrl.tsk_id[i].exist = FALSE;
  }
  mgr->devconf                = &g_TRACE_cfg;
  mgr->chan.stub.tsk_id.exist = FALSE;
  mgr->ctrl.wr_idle           = FALSE;
  mgr->ctrl.swi_req           = FALSE;
  mgr->ctrl.snd_status 	      = TRUE; 

/*jov1kor-CRQ.No-XXXX- Implementation for Trace Internal Commands*/
  mgr->ctrl.cmd_info.rd_wait = FALSE;

  mgr->prxy.blk_mode	= TRACE_NO_BLOCK_MODE;
  mgr->prxy.filesz      = (U32)g_TRACE_cfg.prxy_log_sz;
  mgr->prxy.max_logsz  = (U32)g_TRACE_cfg.prxy_max_sz;

}

/**
 * Initialize Trace manager(shared part).
 *
 * \parm mgr Pointer to Trace manager
 *
 * return \li E_OK    if successful
 *                    else error values returned by concrete implementation.
 */
LOCAL void TRACE_init_sh_mgr(TRACE_mgr* mgr);
LOCAL void TRACE_init_sh_mgr(TRACE_mgr* mgr)
{

  S32 i   = 0; 
  TRACE_notify_ctrl_sh notify = {(TR_MAX_COMP_COUNT-1), 0}; 
  
  
  /* Set user specified values, if available otherwise, set default values */ 
  mgr->sh->trc.d_cnfg.swi_chan           = TRACE_NULLDEV;
  mgr->sh->trc.d_cnfg.actv_chan          = (TRACE_iodev) g_TRACE_cfg.output_mode;
  mgr->sh->trc.d_cnfg.flgs.svcfg_onexit  = FALSE;
  mgr->sh->trc.d_cnfg.flgs.trip          = (TRACE_trip_mode)g_TRACE_cfg.trip_mode;
  mgr->sh->trc.d_cnfg.flgs.app_filter    = (U8)g_TRACE_cfg.app_filter;
  mgr->sh->trc.d_cnfg.flgs.timestamp     = (TRACE_TIMESTAMP_MODE)g_TRACE_cfg.timestamp_mode;
  mgr->sh->trc.d_cnfg.flgs.blck_mode     = TRACE_NO_BLOCK_MODE;
 

  mgr->sh->prxy.timestamp_flg  = (U8)TRACE_TIMESTAMP_DISABLE;
  mgr->sh->prxy.flush_mode     = (TRACE_TIMESTAMP_MODE)g_TRACE_cfg.prxy_flush_mode;
  mgr->sh->prxy.bfile_sz       = (U32)g_TRACE_cfg.prxy_log_sz;
  mgr->sh->prxy.stor_med_sz    = (U32)g_TRACE_cfg.prxy_max_sz;

  strncpy((VP)mgr->sh->prxy.cfg_file_path, (VP)g_TRACE_cfg.prxy_cfg_loc,
          TRACE_STORAGE_DEV_LEN);

  strncpy((VP)mgr->sh->prxy.bin_file_path, (VP)g_TRACE_cfg.prxy_bin_loc,
          TRACE_STORAGE_DEV_LEN);

  /* #SWGIII-7042 Fix*/
  strncpy((VP)mgr->sh->trc.d_cnfg.chnl_skt_loc, (VP)g_TRACE_cfg.chnl_skt_loc,
          TRACE_STORAGE_DEV_LEN);
  strncpy((VP)mgr->sh->trc.d_cnfg.chnl_skt_ntfy_loc, (VP)g_TRACE_cfg.chnl_skt_ntfy_loc,
          TRACE_STORAGE_DEV_LEN);
  for(i = 0; i < (S32)TRACE_MAX_NOTIFY_EVT; i++)
  {
    mgr->sh->notify[i] = notify;
  }
    
  mgr->sh->ctrl.chnl_route.chn_id = 0;
  /*jov1kor-CRQ.No-XXXX- Implementation for Trace Internal Commands*/
  /*Init all the variables required for the internal commands*/
  memset(&mgr->sh->sndcmd.cmd_buf, 0 , sizeof(mgr->sh->sndcmd.cmd_buf));
  mgr->sh->sndcmd.buf_len		= 0;
  mgr->sh->sndcmd.cmd_cmplt		= TRUE;
  mgr->sh->wr_tsk_state			= 0;
}

/**
 * Create Trace task and bind to desired CPU core.
 *
 * \parm task   Task Entry point
 * \parm index  Index into array of Trace tasks
 * \parm mgr    Pointer to Trace manager
 * \parm tsk_nm Pointer to task name
 *
 * return \li E_OK    if successful
 *                    else error values returned by concrete implementation.
 */
EXPORT ER TRACE_init_task(TRACE_task task, TRACE_max_task tr_index, TRACE_mgr* mgr)
{
    ER     rc           = E_OK;
    S32    stage        = 0;
    pthread_attr_t attr;

    memset(&attr, 0, sizeof(attr) );
    if(NULL != mgr)
    {
      while((stage < 3) && (rc == E_OK))
      {
        switch(stage)
        {
            case 0:
                rc = pthread_attr_init(&attr);
            break;

            case 1:
                rc = pthread_attr_setstacksize(&attr, 
                        (size_t)mgr->devconf->stksz[tr_index]);
            break;

            case 2:
                rc = pthread_create(&mgr->ctrl.tsk_id[tr_index].tid,
                                     &attr, task, (VP)mgr);
                if(rc == E_OK)
                {
                   mgr->ctrl.tsk_id[tr_index].exist = TRUE;
                }
            break;

            default:
            break;
        }   
        stage++;
      }
    }
    if(stage > 1)
    {
        /* destroy only if attr init is success */
        rc = pthread_attr_destroy(&attr);
    }
    return rc;
}


/*Added by agv2kor from trace_fe.c for solving compile time issues */
/**
 * Provide shared mem pointer to application
 *
 * \parm  msg        ptr to TRACE_cfg_data 
 * return \li ER     E_OK if unregistered successfully
 *                   E_PAR, otherwise
 */
EXPORT ER TRACE_get_sh_cnfg(TRACE_cfg_data* msg)
{
  ER rc = E_FAIL;
/*SWGIII-6802 Null pointer exception fix */
  if((msg != NULL) && (g_TRACE_mgr!=NULL))
  {
    if((msg->c_cnfg != NULL) && (g_TRACE_mgr->c_cnfg !=NULL))
    {

      *msg->c_cnfg = g_TRACE_mgr->c_cnfg;
      rc = E_OK;
    }
  }
  return rc;
}




/**
 * Trace shutdown sequence.
 *
 * \parm mgr Pointer to Trace manager
 *
 * return \li E_OK    if successful
 *                    else error values returned by concrete implementation.
 */
EXPORT ER TRACE_stop(TRACE_mgr** tmgr)
{
  TRACE_mgr*     mgr = *tmgr;
  ER             rc  = E_OK;
  U32             i  = 0;
  struct { pthread_t tid; S8* exist;  ER* rc;}stub[] = {
    {mgr->chan.stub.tsk_id.tid, &mgr->chan.stub.tsk_id.exist, &mgr->chan.stub.tsk_id.rc},
    {mgr->notify[0].stub.tsk_id.tid, &mgr->notify[0].stub.tsk_id.exist, &mgr->notify[0].stub.tsk_id.rc}
  };
  
  /* stop stub threads */
  for(i = 0; i < UTIL_NO(stub); i++)
  {
    if((*stub[i].exist) == TRUE)
    {
      rc = pthread_cancel(stub[i].tid);
      (*stub[i].rc) = rc;
    }
  }    
  for(i = 0; i < UTIL_NO(stub); i++)
  {
    if( ((*stub[i].rc) == E_OK) && (stub[i].tid != 0) )/*SWGIIX-1260(SWGIIX-1258) Segmentation fault occurs at end of all svg graphics demos:SGX failed*/
    {
      pthread_join(stub[i].tid, NULL);
      (*stub[i].exist) = FALSE;
    }
  }
  /* close channel socket */
  TRACE_socket_close(&mgr->chan.stub.socket);
  /* save trace configuration to persistent storage */
  if(TRUE == mgr->trc.sh->d_cnfg.flgs.svcfg_onexit)
  {
  /* filesystems won't be available at this point
   * doesn't make sense to call TRACE_save_cfg()
   */
  }
  /* Unintialise Static Lib */
  TRACE_STATLIB_uninit();
  
  /* Do not delete event and large msg locks 
   * they might still be used by other processes
   * they get re-created only when shared memory is created newly
   * FixMe: release them only when the last process executes 
   */
  
  /* close process-wide semaphore
   * caution: do not unlink either sem or shm
   * otherwise, any attempt to open a sem or shm from
   * a new client(process) will get a totally new ones
   * they are destroyed only during system restart
   */
  TRACE_sharedmem_destroy(&mgr->shm, FALSE);
  mgr->sh = NULL;

  /* Release memory related to Trace manager */
  if(mgr != NULL)
  {
    free(mgr);
    *tmgr = NULL;
  }
  
  return rc;
}

/**
 * Initialize Trace info residing in Shared mem
 * This initialization should be done exactly once
 * \parm None
 *
 * return \li E_OK    if successful
 *                    else error values returned by concrete implementation.
 */
LOCAL ER TRACE_sharedinfo_init(TRACE_mgr* mgr)
{
  ER         rc  = E_OK;
  int i;
  TRACE_q_sh q_sh;

  memset(&q_sh, 0, sizeof(q_sh));
  if(mgr != NULL)
  {
    /* Init Trace manager - shared info */
    TRACE_init_sh_mgr(mgr);

    /* enable static class */
    TRACE_ena_static_clas(mgr);
       
    /* Initialize Ringbuffers - shared info */
    /* status Q */
    q_sh.blck_mode = TRACE_NO_BLOCK_MODE;    
    q_sh.wr        = 0;
    q_sh.rd        = 0;
    q_sh.pkt_sz    = sizeof(TRACE_OUT_MSG);
    q_sh.dat_avl   = (S32)TRACE_DAT_AVL_STAT_BUF;
    q_sh.wai_4_spc = (S32)TRACE_WAIT_4_STAT_BUF_SPACE;
    TRACE_ini_q_sh(&mgr->sh->stat.buf, &q_sh);

    /* channel Q */
    q_sh.blck_mode = TRACE_BLOCK_MODE;
    q_sh.wr        = 0;
    q_sh.rd        = 0;
    q_sh.pkt_sz    = sizeof(TRACE_IN_MSG);
    q_sh.dat_avl   = (S32)TRACE_DAT_AVL_CHNL_BUF;
    q_sh.wai_4_spc = (S32)TRACE_WAIT_4_CHNL_BUF_SPACE;
    TRACE_ini_q_sh(&mgr->sh->chan.buf, &q_sh);

    /* Proxy Q*/
    q_sh.blck_mode = TRACE_NO_BLOCK_MODE;
    q_sh.wr        = 0;
    q_sh.rd        = 0;
    q_sh.pkt_sz    = sizeof(TRACE_TRACEOUT_MSG);
    q_sh.dat_avl   = (S32)TRACE_DAT_AVL_PRXY_BUF;
    q_sh.wai_4_spc = (S32)TRACE_WAIT_4_PRXY_BUF_SPACE;
    TRACE_ini_q_sh(&mgr->sh->prxy.buf, &q_sh);

    /* Trace Q */
    q_sh.blck_mode   = TRACE_NO_BLOCK_MODE;
    q_sh.wr          = 0;
    q_sh.rd          = 0;
    q_sh.pkt_sz      = sizeof(TRACE_TRACEOUT_MSG);
    q_sh.dat_avl     = (S32)TRACE_DAT_AVL_TRC_BUF;
    q_sh.wai_4_spc   = (S32)TRACE_WAIT_4_TRC_BUF_SPACE;
    TRACE_ini_q_sh(&mgr->sh->trc.buf, &q_sh);

    /* Create event flag & Mutex*/
    for(i = 0; (i < EVT_MAX) && (rc >= E_OK); i++)
      rc = TRACE_create_flag(&mgr->sh->evt_id[i]);

    if(rc >= E_OK)
    {
      rc = TRACE_mutex_init(&mgr->sh->trc.lrgmsg_lock);

        rc = sem_init(&mgr->sh->sem, PTHREAD_PROCESS_SHARED, 1);
        if(E_OK != rc)
        {
          TRACE_SYSLOG(TRACE_SYSLOG_ERROR, "Gen3: Initialization of sync Semaphore failed\n");
        }
    }
	
	/*jov1kor<25.07.2012>-CRQ:XXXX - Mutex init for send cmd purpose is to write the data to shared memory */
	if(rc >= E_OK)
	{
	  rc = TRACE_mutex_init(&mgr->sh->sndcmd.lock);
	}
  }
  else
  {
    rc = E_FAIL;
  }
  return rc;
}


/**
* Retrieves cmd line params
*
* \parm  argc number of params
* \parm  argv pointer to argument array       
* \parm  param pointer to TRACE_cmd_param structure
* return \li E_OK    if successful
*                    else error values returned by concrete implementation.
*/
LOCAL ER TRACE_get_cmd_param(S32 argc, char** argv,
                               TRACE_cmd_param* param)
{
  ER rc    = E_OK;
  S32 flag = 0;
  S32 option_index = 0;
  struct  option long_options[] = {
      {"help", 0, 0, 0},
      {"port", 1, 0, 0},
      {"server", 1, 0, 0},
      {"trccfg", 1, 0, 0},
      {"com", 1, 0, 0},
      {"keepalive", 0, 0, 0},
      {0, 0, 0, 0}
    };

  do
  {    
      if((flag = getopt_long(argc, (char**)argv, "hp:s:t:c:k",  
                              long_options, &option_index)) >= 0)
    {
      
     if(flag == 0) 
     {
       if(0 == strcmp(long_options[option_index].name, "server") )
       {
         flag = 's';              
       }
       else if(0 == strcmp(long_options[option_index].name, "port") )
       {
           flag = 'p'; 
       }
       else if(0 == strcmp(long_options[option_index].name, "help") )
       {
           flag = 'h';              
       }
       else if(0 == strcmp(long_options[option_index].name, "trccfg") )
       {
           flag = 't';
       }
       else if(0 == strcmp(long_options[option_index].name, "com") )
       {
           flag = 'c';
       }
       else if(0 == strcmp(long_options[option_index].name, "keepalive") )
       {
           flag = 'k';
       }

       else
       {
       }
       
     }
      switch(flag)
      {          
         /* handling short options '-' */
          case 'h':
          {
            printf("Usage:-\ntrace_be --server=<ip> --port=<port number> --trccfg=<trace cfg loc> --com=<serial device> --keepalive\n\t or\n \
                             trace_be -s <ip> -p <port number> -t <trace cfg loc> -c <serial device> -k\n");
            rc = E_FAIL;
            break;
          }
          case 'p':
          {
            if(optarg)
            {
              *param->tcp_port_no = atoi(optarg);
            }
          }
          break;
          case 's':
          {
            if(optarg)
            {
              (void)strncpy((VP)param->tcp_ip_addr,(VP)optarg, L_IPADDR);
            }
          }
          break;
          case 't':
          {
            if(optarg)
            {
              (void)strncpy((VP)param->trc_cfg_loc,(VP)optarg, TRACE_DEVNM_LEN);
            }
          }
          break;
          case 'c':
          {
            if(optarg)
            {
              (void)strncpy((VP)param->serial_dev_nm, (VP)optarg, TRACE_DEVNM_LEN);
            }
          }
          break;
          case 'k':
          {
            /*No need to check for optarg, since argument is not there*/
            *param->tcp_keepAlive = FALSE;
          }
          break;
 
          default:
             /* do nothing*/;
          break;
        }    
    }
  }while((flag >= 0)&& (rc >= E_OK));
  return rc; 
}

/* Note : the length needed for uname, gname and mode_str is defined
 * by the pattern (TRACE_SOCKET_FOLDER_PATTERN)
 * Note : No null pointer checks for inputs
 */
LOCAL ER TRACE_find_matching_socket_cfg (FILE *tmpfiles_cfg, const char *folder,
        char *uname, char *gname, char *mode_str) {
    ER rc = E_OK;

    char buffer[TRACE_DEVNM_LEN + 1];
    char* line;
    char folder_buf[TRACE_SOCKET_FOLDER_PATTERN_FOLDER_LEN];

    int matching_items;
    int matching_chars;

    /* check if folder contains % */
    if (strchr(folder,'%') != NULL) {
        TRACE_SYSLOG(TRACE_SYSLOG_ERROR,
                "Folder must not include %%. Skip socket folder(%s) setup.\n",
                folder);
        rc = E_FAIL;
    }

    if (strlen(folder) > TRACE_SOCKET_FOLDER_PATTERN_EXP_FOLDER_LEN) {
        TRACE_SYSLOG(TRACE_SYSLOG_ERROR,
                "Folder must not longer than %d chars. Skip socket folder(%s) setup.\n",
                TRACE_SOCKET_FOLDER_PATTERN_EXP_FOLDER_LEN,folder);
        rc = E_FAIL;
    }

    /* search for the first matching line */
    if (rc == E_OK) {
        rewind (tmpfiles_cfg);

        matching_items = 0;
        line = fgets(&buffer[0], TRACE_DEVNM_LEN + 1, tmpfiles_cfg);

        while ((line != NULL) && (rc == E_OK)) {
            /* initialize char used to detect unexpected long folder names */
            folder_buf[TRACE_SOCKET_FOLDER_PATTERN_EXP_FOLDER_LEN] = '\0';

            matching_items = sscanf(line, TRACE_SOCKET_FOLDER_PATTERN,
                    &folder_buf[0], mode_str, uname, gname, &matching_chars);

            /* check that we found all and still did not reach max line length */
            if ( (matching_items >= 4) && (strcmp(folder,&folder_buf[0])==0) ) {
                line = NULL;

               if ('\0' != folder_buf[TRACE_SOCKET_FOLDER_PATTERN_EXP_FOLDER_LEN]) {
                   TRACE_SYSLOG(TRACE_SYSLOG_ERROR,
                           "Unexpected long folder name in configuration. Skip socket folder(%s) setup.\n",
                           folder);
                   rc = E_FAIL;
               }
               if (matching_chars >= TRACE_DEVNM_LEN) {
                   TRACE_SYSLOG(TRACE_SYSLOG_ERROR,
                           "Matching line to long - might be incomplete. Skip socket folder(%s) setup.\n",
                           folder);
                   rc = E_FAIL;
               }

            } else {
                /* next line */
                matching_items = 0;
                line = fgets(&buffer[0], TRACE_DEVNM_LEN + 1, tmpfiles_cfg);
            }
        }

        if ((matching_items == 0) && (rc == E_OK)) {
            /* no matching lines - abort setup */
            TRACE_SYSLOG(TRACE_SYSLOG_NOTICE,
                    "No matching line found in configuration. Skip socket folder(%s) setup.\n",
                    folder);
            rc = E_ABORT;
        }
    }

    return rc;
}

/*
 * Note : No null pointer checks for inputs
 */
LOCAL ER TRACE_resolve_socket_cfg_user (const char *uname, uid_t *uid,
        char* getpwgr_buf_ptr, size_t getpwgr_buf_len, const char *folder) {
    ER rc = E_OK;
    struct passwd tmp_user_buf;
    struct passwd *tmp_user;

    if (strcmp(uname,TRACE_SOCKET_FOLDER_IGNORE_ARG) != 0) {
        /* resolve user */
        getpwnam_r(uname, &tmp_user_buf,
                getpwgr_buf_ptr, getpwgr_buf_len,
                &tmp_user);

        if (tmp_user == NULL) {
            TRACE_SYSLOG(TRACE_SYSLOG_ERROR,
                    "User %s does not exist. Skip socket folder(%s) setup.\n",
                    uname, folder);
            rc = E_FAIL;
        } else {
            *uid = tmp_user->pw_uid;
        }
    }

    return rc;
}

/*
 * Note : No null pointer checks for inputs
 */
LOCAL ER TRACE_resolve_socket_cfg_group (const char *gname, gid_t *gid,
        char* getpwgr_buf_ptr, size_t getpwgr_buf_len, const char *folder) {
    ER rc = E_OK;
    struct group tmp_grp_buf;
    struct group *tmp_grp;

    if (strcmp(gname,TRACE_SOCKET_FOLDER_IGNORE_ARG) != 0) {
        /* resolve group */
        getgrnam_r(gname, &tmp_grp_buf,
                getpwgr_buf_ptr, getpwgr_buf_len,
                &tmp_grp);

        if (tmp_grp == NULL) {
            TRACE_SYSLOG(TRACE_SYSLOG_ERROR,
                    "Group %s does not exist. Skip socket folder(%s) setup.\n",
                    gname, folder);
            rc = E_FAIL;
        } else {
            *gid = tmp_grp->gr_gid;
        }
    }

    return rc;
}

/*
 * Note : No null pointer checks for inputs
 */
LOCAL ER TRACE_resolve_socket_cfg_mode (char *mode_str, mode_t *mode, const char *folder) {
    ER rc = E_OK;

    unsigned int tmp_mode;
    int matching_items;
    int matching_chars;

    if (strcmp(mode_str,TRACE_SOCKET_FOLDER_IGNORE_ARG) != 0) {
        matching_items=sscanf (mode_str, "%o%n",
                &tmp_mode, &matching_chars);
        /* parse octal number - check if the complete string has been used */
        if ((matching_items >= 1) && (strlen(mode_str)==(size_t)matching_chars)) {
            *mode = (mode_t)tmp_mode;
        } else {
            TRACE_SYSLOG(TRACE_SYSLOG_ERROR,
                    "Parsing mode (%s) failed. Skip socket folder(%s) setup.\n",
                    mode_str, folder);
            rc = E_FAIL;
        }
    }
    if (((*mode & 0777) == 0) && (rc == E_OK)) {
        TRACE_SYSLOG(TRACE_SYSLOG_ERROR,
                "User,group,other permissions all zero not supported. Skip socket folder(%s) setup.\n",
                 folder);
        rc = E_FAIL;
    }

    return rc;
}


/*
 * Note : No null pointer checks for inputs
 */
LOCAL ER TRACE_get_credentials_from_socket_cfg (FILE *tmpfiles_cfg, const char *folder,
        char** getpwgr_buf_ptr, size_t getpwgr_buf_len,
        uid_t *uid, gid_t *gid, mode_t *mode) {
    ER rc;

    char uname[TRACE_SOCKET_FOLDER_PATTERN_USER_LEN];
    char gname[TRACE_SOCKET_FOLDER_PATTERN_GRP_LEN];
    char mode_str[TRACE_SOCKET_FOLDER_PATTERN_MODE_LEN];

    /* initialize chars used to detect unexpected long inputs */
    mode_str[TRACE_SOCKET_FOLDER_PATTERN_EXP_MODE_LEN] = '\0';
    uname[TRACE_SOCKET_FOLDER_PATTERN_EXP_USER_LEN] = '\0';
    gname[TRACE_SOCKET_FOLDER_PATTERN_EXP_GRP_LEN] = '\0';

    rc = TRACE_find_matching_socket_cfg(tmpfiles_cfg, folder,
            &uname[0], &gname[0], &mode_str[0]);

    if (rc == E_OK) {
        /* check if the protection char is still 0 -
         * otherwise we can not be sure that the content is complete */
        if (('\0' != mode_str[TRACE_SOCKET_FOLDER_PATTERN_EXP_MODE_LEN]) ||
            ('\0' != uname[TRACE_SOCKET_FOLDER_PATTERN_EXP_USER_LEN]) ||
            ('\0' != gname[TRACE_SOCKET_FOLDER_PATTERN_EXP_GRP_LEN]) ) {
            TRACE_SYSLOG(TRACE_SYSLOG_ERROR,
                    "Unexpected long uname, gname or mode in configuration. Skip socket folder(%s) setup.\n",
                    folder);
            rc = E_FAIL;
        }
    }

    if (rc == E_OK) {
        if (*getpwgr_buf_ptr == NULL) {
            *getpwgr_buf_ptr = malloc(getpwgr_buf_len);
        }
        if (*getpwgr_buf_ptr == NULL) {
            TRACE_SYSLOG(TRACE_SYSLOG_ERROR,
                    "Out of memory. Skip socket folder(%s) setup.\n",
                    folder);
            rc = E_FAIL;
        }
    }

    if (rc == E_OK) {
        rc = TRACE_resolve_socket_cfg_user (&uname[0], uid,
                *getpwgr_buf_ptr, getpwgr_buf_len, folder);
    }
    if (rc == E_OK) {
        rc = TRACE_resolve_socket_cfg_group (&gname[0], gid,
                *getpwgr_buf_ptr, getpwgr_buf_len, folder);
    }
    if (rc == E_OK) {
        rc = TRACE_resolve_socket_cfg_mode (&mode_str[0], mode, folder);
    }

    return rc;
}

/* Note : getpwgr_buf_ptr might be NULL and needs to be allocated when needed the
 * first time - afterwards the memory is shared and freed in the calling functions
 * Note : No null pointer checks for inputs
 */
LOCAL ER TRACE_initialise_socket_folder(FILE *tmpfiles_cfg, const char *folder,
        char** getpwgr_buf_ptr, size_t getpwgr_buf_len) {
	ER rc;

	uid_t uid = (mode_t)-1;
	gid_t gid = (mode_t)-1;
	mode_t mode = 0;
	mode_t cur_umask;

	rc = TRACE_get_credentials_from_socket_cfg (tmpfiles_cfg, folder,
	        getpwgr_buf_ptr, getpwgr_buf_len, &uid, &gid, &mode);

    if (rc == E_OK) {
        /* try to set rights - ignore all errors like missing permissions or already existing */

        /* store umask */
        cur_umask = umask(0);

        /* try mkdir - ignore all errors */
        mkdir (folder, TRACE_SOCKET_FOLDER_INITIAL_MODE);

        /* restore umask */
        umask(cur_umask);

        /* try chown - ignore all errors */
        chown (folder, uid, gid);
        /* try chmod - ignore all errors */
        chmod (folder, mode);
    }

	return rc;
}

/*
 * Note : No null pointer checks for inputs
 */
LOCAL void TRACE_initialise_socket_folders(TRACE_cfg *cfg)
{
	char chnl_skt_loc[TRACE_DEVNM_LEN + 1];
	char chnl_skt_ntfy_loc[TRACE_DEVNM_LEN + 1];

	char* chnl_skt_loc_folder = NULL;
	char* chnl_skt_ntfy_loc_folder = NULL;

	FILE *tmpfiles_cfg;

    size_t getpwnam_getgrnam_buf_len = (size_t)sysconf(_SC_GETGR_R_SIZE_MAX);
    size_t getpw_size = (size_t)sysconf(_SC_GETPW_R_SIZE_MAX);
    char *getpwnam_getgrnam_buf;


	/* need to copy as dirname will alter the string */
	strcpy(&chnl_skt_loc[0], (char *)&(cfg->chnl_skt_loc[0]));
	strcpy(&chnl_skt_ntfy_loc[0], (char *)&(cfg->chnl_skt_ntfy_loc[0]));

	if (strcmp(&chnl_skt_loc[0], TRACE_EMPTY_STR) != 0) {
		chnl_skt_loc_folder = dirname (&chnl_skt_loc[0]);

		if (chnl_skt_loc_folder != &chnl_skt_loc[0]) {
			/* the specified folder did not contain a directory (i.e. "." returned) */
            TRACE_SYSLOG(TRACE_SYSLOG_ERROR,
                    "Control socket config (%s) does not contain a directory\n",
                    (char *)&(cfg->chnl_skt_loc[0]));
			chnl_skt_loc_folder = NULL;
		}
	}
	if (strcmp(&chnl_skt_ntfy_loc[0], TRACE_EMPTY_STR) != 0) {
		chnl_skt_ntfy_loc_folder = dirname (&chnl_skt_ntfy_loc[0]);

		if (chnl_skt_ntfy_loc_folder != &chnl_skt_ntfy_loc[0]) {
			/* the specified folder did not contain a directory (i.e. "." returned) */
            TRACE_SYSLOG(TRACE_SYSLOG_ERROR,
                    "Notify socket config (%s) does not contain a directory\n",
                    (char *)&(cfg->chnl_skt_ntfy_loc[0]));
            chnl_skt_ntfy_loc_folder = NULL;
		}
	}

	/* in case both are existing and have the same name we just
	 * need to create directory once */
	if ((chnl_skt_ntfy_loc_folder != NULL) && (chnl_skt_loc_folder != NULL) &&
		(strcmp(chnl_skt_ntfy_loc_folder, chnl_skt_loc_folder) == 0) ) {
		chnl_skt_ntfy_loc_folder = NULL;
	}

	if ((chnl_skt_ntfy_loc_folder != NULL) || (chnl_skt_loc_folder != NULL)) {
		if (strcmp((char *)&(cfg->tmpfilesd_cfg_path[0]), TRACE_EMPTY_STR) == 0) {
            /* No configuration given - silently skip setup */
            return;
		}

		/* Determine memory needed for resolving user or group.
		 * Malloc will be done inside the functions when the memory
		 * is needed the first time. Afterwards the memory will be reused.
		 */
	    getpwnam_getgrnam_buf_len = (size_t)sysconf(_SC_GETGR_R_SIZE_MAX);
	    getpw_size = (size_t)sysconf(_SC_GETPW_R_SIZE_MAX);
	    if (getpw_size > getpwnam_getgrnam_buf_len) {
	        getpwnam_getgrnam_buf_len = getpw_size;
	    }
	    /*getpwnam_getgrnam_buf = malloc(getpwnam_getgrnam_buf_len);*/
	    getpwnam_getgrnam_buf = NULL;

		tmpfiles_cfg = fopen ((char *)cfg->tmpfilesd_cfg_path, "r");
		if (!tmpfiles_cfg) {
			/* just a notice as non root applications might not be able to access
			 * this configuration for reading
			 */
            TRACE_SYSLOG(TRACE_SYSLOG_NOTICE,
                    "Failed to open %s (%s). Skip socket folders setup.\n",
                    TRACE_TMPFILESD_CFG,
                    (char *)&(cfg->tmpfilesd_cfg_path[0]));
			return;
		}

		if (chnl_skt_loc_folder != NULL) {
			TRACE_initialise_socket_folder (tmpfiles_cfg, chnl_skt_loc_folder,
			        &getpwnam_getgrnam_buf, getpwnam_getgrnam_buf_len);
		}
		if (chnl_skt_ntfy_loc_folder != NULL) {
			TRACE_initialise_socket_folder (tmpfiles_cfg, chnl_skt_ntfy_loc_folder,
                    &getpwnam_getgrnam_buf, getpwnam_getgrnam_buf_len);
		}

		fclose (tmpfiles_cfg);

		/* free the memory - allocated inside TRACE_initialise_socket_folder */
		if (getpwnam_getgrnam_buf != NULL) {
		    free (getpwnam_getgrnam_buf);
		}
	}
}


/* Dummy function for trace init which only returns */
EXPORT ER TRACE_start_dummy()
{
   return E_OK;
}

/**
 * Initialize Trace mgr
 *
 * \parm pointer to cmd arg and number of command line arguments
 *
 * return \li E_OK    if successful
 *                    else error values returned by concrete implementation.
 */
EXPORT ER TRACE_start()  /*  SWGIIX-2071: CommandLine parameter not recieved in trace be */
{
  TRACE_q    q;                       
  TRACE_mgr* mgr                      = NULL;
  ER         rc                       = E_OK;
  S32        stage                    = 0;
  size_t     sz                       = 0;
  U8*        mem                      = 0;
  U8*        shmem                    = 0;
  size_t     proxy_cl_sz              = 0;
  size_t     chnlqsz                  = 0;
  size_t     statqsz                  = 0;
  size_t     trcqsz                   = 0;
  size_t     pxyqsz                   = 0;
  size_t     claslvl_cnfg_sz          = 0;
  size_t     chan_inf_sz              = (TRACE_CALBK_LEN_SZ + 
                                         1 /* chksum */     +
                                         1 /* chnl_id */);
  U8*        wr_stat[TRACE_MAX_INDEX] = {NULL};
  U8*        rd_q[TRACE_MAX_INDEX]    = {0};
  U8*        cnfg                     = NULL;

  memset(&q, 0, sizeof(q));



/* PRQA: Lint Message 613: mgr pointer will not be null for the stages > 1 */
/*lint -save -e613 */
  if(g_TRACE_mgr == NULL)
  {
    /*SWGIII-3621: TRACE static constructor for init() dangerous */
    /*Mutex lock for initialization*/
    rc = pthread_mutex_lock(&init_lock);
    /* do initialization, if not done already */

    while((stage < 10) && (rc >= E_OK)&& (NULL == g_TRACE_mgr))
    {
      switch(stage)
      {
        case 0: /* Read DEVCONF */
          rc = TRACE_rd_devconf();
        break;

        case 1: /* allocate Trace Mgr */
          sz  = sizeof(TRACE_mgr) + g_TRACE_cfg.lrg_pkt_sz +
              chan_inf_sz + sizeof(TRACE_class_cnfg);

          mem = (U8*) calloc(sz , sizeof(U8));
          if(mem != NULL)
          {
            mgr = (TRACE_mgr*)((VP)mem);

            /* Moved the following section from case 4 to here */
            /* Initialize Trace mgr - per process info */
            TRACE_init_mgr(mgr);

            /* assign memory from local heap */
            mem              += sizeof(TRACE_mgr);
            mgr->chan.lrg_pkt = mem;
            mem              += (g_TRACE_cfg.lrg_pkt_sz + chan_inf_sz);
            mgr->c_cnfg      = (TRACE_class_cnfg*)((VP)mem);
            mem              += sizeof(TRACE_class_cnfg);

          }
          else
          {
            rc = E_FAIL;
          }
        break;

        case 2: /* calculate meomory size required for Trace */

          trcqsz = g_TRACE_cfg.trace_q_sz * (sizeof(TRACE_TRACEOUT_MSG)); 
          
          chnlqsz = (g_TRACE_cfg.chan_q_sz * (sizeof(TRACE_IN_MSG)));

          statqsz = (g_TRACE_cfg.stat_q_sz * (sizeof(TRACE_OUT_MSG)));

          pxyqsz  = (g_TRACE_cfg.prxy_q_sz * (sizeof(TRACE_TRACEOUT_MSG)));
          proxy_cl_sz = (sizeof(TRACE_proxy_file_cl) * TRACE_MAX_CLASS);
          /*Making by defualt the size as 256*256 instead reading the actuall component max class value */
          claslvl_cnfg_sz =(TRACE_MAX_COMP_CNT*TRACE_MAX_COMP_CNT);


        sz = (TRACE_ALIGN_UP(TRACE_BYTE_4, sizeof(TRACE_mgr_sh))                                   +
             TRACE_ALIGN_UP(TRACE_BYTE_4, claslvl_cnfg_sz)                                        +
             TRACE_ALIGN_UP(TRACE_BYTE_4, proxy_cl_sz)                                            +
             TRACE_ALIGN_UP(TRACE_BYTE_4,((g_TRACE_cfg.trace_q_sz + g_TRACE_cfg.chan_q_sz         +
                g_TRACE_cfg.stat_q_sz + g_TRACE_cfg.prxy_q_sz)* (sizeof(U8))))                    +
             TRACE_ALIGN_UP(TRACE_BYTE_4, (trcqsz + chnlqsz  + statqsz + pxyqsz))                 +
             TRACE_ALIGN_UP(TRACE_BYTE_4, (TR_LAST_LAUNCH_CHAN * (sizeof(TRACE_callback_mgr))) )  +
             TRACE_ALIGN_UP(TRACE_BYTE_4, (sizeof(TRACE_TRACEOUT_MSG)) )                          +
             TRACE_ALIGN_UP(TRACE_BYTE_4, (sizeof(TRACE_TRACEOUT_MSG)) )                          +
             TRACE_ALIGN_UP(TRACE_BYTE_4, (sizeof(TRACE_IN_MSG)) )                                +
             TRACE_ALIGN_UP(TRACE_BYTE_4, (sizeof(TRACE_OUT_MSG)) )                               +
             TRACE_ALIGN_UP(TRACE_BYTE_4, (TR_MAX_COMP_COUNT * sizeof(TRACE_notify_inf) * 2) ));

        break;

       case 3: /* create shared memory */
          rc = TRACE_sharedmem_create(&mgr->shm, (S8*)TRACE_SHM_NM, sz);
          if(rc >= E_OK)
          {
            shmem  = (U8*)TRACE_sharedmem_mem(&mgr->shm);
            if(shmem != NULL)
            {
              mgr->sh = (TRACE_mgr_sh*)((VP)shmem);
            }
            else
            {
              rc = E_FAIL;
            }
          }
        break;

       case 4:
          /* assign memory from shared mem */
          shmem                 += TRACE_ALIGN_UP(TRACE_BYTE_4, sizeof(TRACE_mgr_sh));
          cnfg                   = shmem;
          shmem                 += TRACE_ALIGN_UP(TRACE_BYTE_4, claslvl_cnfg_sz);
          rd_q[TRACE_INDEX_0]    = shmem;
          shmem                 += TRACE_ALIGN_UP(TRACE_BYTE_4, sizeof(TRACE_OUT_MSG));
          rd_q[TRACE_INDEX_1]    = shmem;
          shmem                 += TRACE_ALIGN_UP(TRACE_BYTE_4, sizeof(TRACE_IN_MSG));
          rd_q[TRACE_INDEX_2]    = shmem;
          shmem                 += TRACE_ALIGN_UP(TRACE_BYTE_4, sizeof(TRACE_TRACEOUT_MSG));
          rd_q[TRACE_INDEX_3]    = shmem;
          shmem                 += TRACE_ALIGN_UP(TRACE_BYTE_4, sizeof(TRACE_TRACEOUT_MSG));
          wr_stat[TRACE_INDEX_0] = shmem;
          shmem                 += TRACE_ALIGN_UP(TRACE_BYTE_4, g_TRACE_cfg.stat_q_sz);
          wr_stat[TRACE_INDEX_1] = shmem;
          shmem                 += TRACE_ALIGN_UP(TRACE_BYTE_4, g_TRACE_cfg.chan_q_sz);
          wr_stat[TRACE_INDEX_2] = shmem;
          shmem                 += TRACE_ALIGN_UP(TRACE_BYTE_4, g_TRACE_cfg.trace_q_sz);
          wr_stat[TRACE_INDEX_3] = shmem;
          shmem                 += TRACE_ALIGN_UP(TRACE_BYTE_4, g_TRACE_cfg.prxy_q_sz);

          mgr->chan.cmgr         = (TRACE_callback_mgr*)(VP)shmem;
          shmem                 += TRACE_ALIGN_UP(TRACE_BYTE_4, (sizeof(TRACE_callback_mgr)*(S32)TR_LAST_LAUNCH_CHAN) );

          mgr->notify[TRACE_APP_FILTER].inf = (TRACE_notify_inf*)(VP)shmem;
          shmem                 += TRACE_ALIGN_UP(TRACE_BYTE_4, (sizeof(TRACE_notify_inf) * TR_MAX_COMP_COUNT) );
          mgr->notify[TRACE_TRIP_STATUS].inf
                                 = (TRACE_notify_inf*)(VP)shmem;
          shmem                 += TRACE_ALIGN_UP(TRACE_BYTE_4, (sizeof(TRACE_notify_inf) * TR_MAX_COMP_COUNT) );
          mgr->prxy.cl           = shmem;
          shmem                 += TRACE_ALIGN_UP(TRACE_BYTE_4, proxy_cl_sz);

        break;

        case 5: /* Initialize Ringbuffers - per process */

          /* Status Q */
          q.wr_stat   = wr_stat[TRACE_INDEX_0];
          q.buf       = rd_q[TRACE_INDEX_0];
          q.start     = shmem;
          q.end       = q.start + TRACE_ALIGN_UP(TRACE_BYTE_4, statqsz);
          q.sh        = &mgr->sh->stat.buf;
          q.event     = &mgr->sh->evt_id[EVT_TRC_Q];
          TRACE_ini_q(&mgr->stat.buf, &q);

          shmem         = q.end;

          /* Channel Q */
          q.wr_stat   = wr_stat[TRACE_INDEX_1];
          q.buf       = rd_q[TRACE_INDEX_1];
          q.start     = shmem;
          q.end       = q.start + TRACE_ALIGN_UP(TRACE_BYTE_4, chnlqsz);
          q.sh        = &mgr->sh->chan.buf;
          q.event     = &mgr->sh->evt_id[EVT_CHNL_Q];
          TRACE_ini_q(&mgr->chan.buf, &q);

          shmem         = q.end;

          /* Proxy Q */
          q.wr_stat   = wr_stat[TRACE_INDEX_3];
          q.buf       = rd_q[TRACE_INDEX_3];
          q.start     = shmem;
          q.end       = q.start + TRACE_ALIGN_UP(TRACE_BYTE_4, pxyqsz);
          q.sh        = &mgr->sh->prxy.buf;
          q.event     = &mgr->sh->evt_id[EVT_PRXY_Q];
          TRACE_ini_q(&mgr->prxy.buf, &q);

          shmem         = q.end;

          /* Trace Q */
          q.wr_stat   = wr_stat[TRACE_INDEX_2];
          q.buf       = rd_q[TRACE_INDEX_2];
          q.start     = shmem;
          q.end       = q.start + TRACE_ALIGN_UP(TRACE_BYTE_4, trcqsz);
          q.sh        = &mgr->sh->trc.buf;
          q.event     = &mgr->sh->evt_id[EVT_TRC_Q];
          TRACE_ini_q(&mgr->trc.buf, &q);

          shmem           = q.end;

        break;

        case 6: /* initialize pointers to shared info */
          mgr->chan.sh = &mgr->sh->chan;
          mgr->stat.sh = &mgr->sh->stat;
          mgr->trc.sh  = &mgr->sh->trc;
          mgr->prxy.sh = &mgr->sh->prxy;
          mgr->notify[TRACE_APP_FILTER].sh  = &mgr->sh->notify[TRACE_APP_FILTER];
          mgr->notify[TRACE_TRIP_STATUS].sh = &mgr->sh->notify[TRACE_TRIP_STATUS];

          mgr->c_cnfg->sh = &mgr->sh->c_cnfg;

          /* allocate class lvl config */
          rc = TRACE_alloc_shared_mem(mgr, cnfg);
        break;

        case 7:
          if(TRUE == TRACE_sharedmem_isnew(&mgr->shm))
          {
            /* initialization of shared mem data is done exactly once
             * do not perform initialization for every process
             */
	        rc = TRACE_sharedinfo_init(mgr);
	        TRACE_sharedmem_init_done(&mgr->shm);
            mgr->sh->shm_size = mgr->shm.size; /*Store size in shm_size by the first*/
            mgr->sh->ctrl.versionCount = TRACE_CURRENT_VERSION;
          }
          else
          {
            /* @agv2kor: Shared memory is already created. Check the size,
             * if different then, return error.
             */
           if(mgr->sh->shm_size != mgr->shm.size)
           {
              TRACE_SYSLOG(TRACE_SYSLOG_ERROR, "Shared Memory size is different; Exiting\n");
              rc = E_FAIL;/*Since error for exit*/
           }
           if(TRACE_CURRENT_VERSION != mgr->sh->ctrl.versionCount)
           {
             TRACE_SYSLOG(TRACE_SYSLOG_ERROR, "FE and BE version are different, so exiting\n");
           }
         }

        break;      
        
        case 8: /* initialise g_TRACE_mgr */
          /* do this after all initialization are done */
	    mgr->ctrl.tcp_keepAlive = g_TRACE_cfg.tcp_keepAlive;
	    
        break;

        case 9: /* initialise folders for control and notify sockets */
            TRACE_initialise_socket_folders (&g_TRACE_cfg);
	/*SWGIII-3621: TRACE static constructor for init() dangerous */
             /* Also assign trace_init to a dummy init function */
            	g_TRACE_mgr = mgr;
		TRACE_init_fp = TRACE_start_dummy;
        break;

        default:
        break;
      }
      stage++;
    }
    /*SWGIII-3621: TRACE static constructor for init() dangerous */
    /* Mutex unlock for initialization */
     (void)pthread_mutex_unlock(&init_lock);
  }
  
  if((rc < E_OK) && (NULL != mgr))
  {
	(void)TRACE_stop(&mgr);
	pthread_mutex_destroy(&init_lock);
  }
/*lint -restore*/
  
  return rc;
}

/**
 * Initialize Command Line parameters
 *
 * \parm pointer to cmd arg and number of command line arguments
 *
 * return \li E_OK    if successful
 *                    else error values returned by concrete implementation.
 */
EXPORT ER TRACE_commandLine_param(S32 argc, char** argv)
{
  ER    rc                       = E_FAIL;
  if( (argc > 0) && (argv != NULL) )
  {
    TRACE_cmd_param param          = {g_TRACE_cfg.tcp_ip_addr, 
                                     &g_TRACE_cfg.tcp_port_no,
                                     g_TRACE_cfg.trc_cfg_loc,
                                     g_TRACE_cfg.serial_dev_nm,
                                     &g_TRACE_cfg.tcp_keepAlive};
    rc = TRACE_get_cmd_param(argc, argv, &param);
  }
  return rc;
}

/*E O F*/
